// Sistema de navegacion para la Escuela de Psicologia
document.addEventListener('DOMContentLoaded', function() {
    const sidebarButtons = document.querySelectorAll('.sidebar-button');
    const sidebarPanels = document.querySelectorAll('.sidebar-panel');

    sidebarButtons.forEach(button => {
        button.addEventListener('click', function() {
            const targetSection = this.getAttribute('data-section');

            // Remover clase active de todos los botones y paneles
            sidebarButtons.forEach(btn => btn.classList.remove('active'));
            sidebarPanels.forEach(panel => panel.classList.remove('active'));

            // Agregar clase active al boton clickeado y su panel correspondiente
            this.classList.add('active');
            document.getElementById(targetSection).classList.add('active');
        });
    });
});
